<?php
	if (Auth::user()->dashboard_style == "light") {
		$bgmenu="blue";
    $bg="light";
    $text = "dark";
} else {
    $bgmenu="dark";
    $bg="dark";
    $text = "light";

}
?>
@extends('layouts.app')
    @section('content')
<a href="{{ url('/dashboard') }}" class="pricing-action btn btn-danger btn-sm">Back to dashboard</a>
        <div class="main-panel bg-dark">
			<div class="content bg-dark">
				<div class="page-inner">
					<div class="mt-2 mb-4">
					<h1 class="title1 text-light">Request for Withdrawal</h1>
					</div>
					<x-danger-alert/>
					<x-success-alert/>
					<div class="mb-5 row">
					@foreach($wmethods as $method)
					<div class="col-lg-4">
						<div class="p-3 rounded card bg-dark">
							<div class="card-body border-danger">
								<h2 class="card-title mb-3 text-light"> {{$method->name}}</h2>
								<h4 class="text-light">Minimum amount: <strong style="float:right;"> {{$settings->currency}}{{$method->minimum}}</strong></h4><br>
								
								<h4 class="text-light">Maximum amount:<strong style="float:right;"> {{$settings->currency}}{{$method->maximum}}</strong></h4><br>
								
								<h4 class="text-light">Charge Type:<strong style="float:right;">{{$method->charges_type}}</strong></h4><br>
								
								<h4 class="text-light">Charges Amount: 
									<strong style="float:right;"> 
										@if ($method->charges_type == "percentage")
											{{$method->charges_amount}}%
										@else
											{{$settings->currency}}{{$method->charges_amount}}
										@endif
									</strong>
								</h4><br>
								
								<h4 class="text-light">Duration:<strong style="float:right;"> {{$method->duration}}</strong></h4><br>
								<div class="text-center">
									@if ($settings->enable_with == "false")
										<button class="btn btn-primary" data-toggle="modal" data-target="#withdrawdisabled"><i class="fa fa-plus"></i> Request withdrawal</button>
									@else
										<form action='{{route('withdrawamount')}}' method="POST">
											@csrf
											<div class="form-group">
												<input type="hidden" value="{{$method->name}}" name="method">
												<button class="btn btn-primary" type='submit'><i class="fa fa-plus"></i> Request withdrawal</button>
											</div>
											
										</form>
										
									@endif
								</div>
							</div>
						</div>
					</div>
					@endforeach
					</div>
					<!-- Withdrawal Modal -->
					<div id="withdrawdisabled" class="modal fade" role="dialog">
						<div class="modal-dialog">
						  <!-- Modal content-->
						  <div class="modal-content">
							<div class="modal-header bg-dark">
							<h4 class="modal-title text-light">Withdrawal Status</h4>
							  <button type="button" class="close text-light" data-dismiss="modal">&times;</button>
							</div>
							<div class="modal-body bg-dark">
								<h4 class="text-light" >Withdrawal is Disabled at the moment, Please check back later</h4>  
							</div>
						  </div>
						</div>
					  </div>
					  <!-- /Withdrawals Modal -->
				</div>
			</div>
	@endsection